<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once "../includes/db.php";
require_once "../includes/auth.php";
check_login();

$message = "";

// Add New Shipment (invoice must be unique, status always Pending)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["action"]) && $_POST["action"] == "add_shipment") {
    $invoice = trim($_POST["invoice"]);
    $item = trim($_POST["item"]);
    $status = "Pending"; // Always pending on add

    // Check if invoice already exists
    $check = $conn->prepare("SELECT id FROM shipments WHERE invoice_number = ?");
    $check->bind_param("s", $invoice);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        $message = "⚠ Invoice already exists! Please use a unique invoice.";
    } else {
        $sql = "INSERT INTO shipments (invoice_number, item_name, status) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            die("SQL Error: " . $conn->error);
        }
        $stmt->bind_param("sss", $invoice, $item, $status);
        $stmt->execute();
        $stmt->close();
        $message = "✅ Shipment added successfully!";
    }
    $check->close();
}

// Update Shipment Progress
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["action"]) && $_POST["action"] == "update_log") {
    $log_invoice = trim($_POST["log_invoice"]);
    $log_status = trim($_POST["log_status"]);
    $log_country = trim($_POST["log_country"]);
    $log_city = trim($_POST["log_city"]);
    $log_description = trim($_POST["log_description"]);

    // Add to tracking_logs
    $sql = "INSERT INTO tracking_logs (invoice_number, location_country, location_city, description, status) 
            VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("SQL Error (Log): " . $conn->error);
    }
    $stmt->bind_param("sssss", $log_invoice, $log_country, $log_city, $log_description, $log_status);
    $stmt->execute();
    $stmt->close();

    // Update status in shipments table
    $updateShipment = $conn->prepare("UPDATE shipments SET status = ? WHERE invoice_number = ?");
    $updateShipment->bind_param("ss", $log_status, $log_invoice);
    $updateShipment->execute();
    $updateShipment->close();

    $message = "✅ Shipment progress updated successfully!";
}

// Get all shipments for dashboard
$result = $conn->query("SELECT * FROM shipments ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard - Shipping Tracker</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="text-primary">📦 Admin Dashboard</h2>
        <a href="logout.php" class="btn btn-outline-danger">Logout</a>
    </div>

    <?php if ($message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <!-- Add Shipment Form -->
    <div class="card mb-4 shadow-sm">
        <div class="card-header bg-primary text-white">Add New Shipment</div>
        <div class="card-body">
            <form method="POST">
                <input type="hidden" name="action" value="add_shipment">
                <div class="mb-3">
                    <label class="form-label">Invoice Number</label>
                    <input type="text" name="invoice" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Item Name</label>
                    <input type="text" name="item" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-success">➕ Add Shipment</button>
            </form>
        </div>
    </div>

    <!-- Update Shipment Progress -->
    <div class="card mb-4 shadow-sm">
        <div class="card-header bg-warning text-dark">Update Shipment Progress</div>
        <div class="card-body">
            <form method="POST">
                <input type="hidden" name="action" value="update_log">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Invoice Number</label>
                        <input type="text" name="log_invoice" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Status</label>
                        <select name="log_status" class="form-select" required>
                            <option value="Pending">Pending</option>
                            <option value="Warehouse">Warehouse</option>
                            <option value="Shipped">Shipped</option>
                            <option value="Transit">Transit</option>
                            <option value="Delivered">Delivered</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Country</label>
                        <input type="text" name="log_country" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">City</label>
                        <input type="text" name="log_city" class="form-control" required>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Description</label>
                        <textarea name="log_description" class="form-control" rows="2" placeholder="e.g. Shipment left warehouse" required></textarea>
                    </div>
                </div>
                <div class="mt-3">
                    <button type="submit" class="btn btn-warning">📌 Add Progress Update</button>
                </div>
            </form>
        </div>
    </div>

    <!-- All Shipments Table -->
    <div class="card shadow-sm">
        <div class="card-header bg-dark text-white">All Shipments</div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped table-bordered m-0">
                    <thead class="table-dark">
                        <tr>
                            <th>Invoice</th>
                            <th>Item</th>
                            <th>Status</th>
                            <th>Last Updated</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row["invoice_number"]) ?></td>
                            <td><?= htmlspecialchars($row["item_name"]) ?></td>
                            <td><?= htmlspecialchars($row["status"]) ?></td>
                            <td><?= $row["updated_at"] ?></td>
                        </tr>
                        <?php endwhile; ?>
                        <?php if ($result->num_rows === 0): ?>
                        <tr><td colspan="4" class="text-center text-muted">No shipments added yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>