<?php 
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once "../includes/db.php";

$shipmentData = null;
$logResults = null;
$invoice = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $invoice = trim($_POST["invoice"]);

    // Fetch basic shipment info
    $stmt = $conn->prepare("SELECT item_name FROM shipments WHERE invoice_number = ?");
    $stmt->bind_param("s", $invoice);
    $stmt->execute();
    $shipmentData = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    // Fetch tracking logs
    $stmt2 = $conn->prepare("SELECT * FROM tracking_logs WHERE invoice_number = ? ORDER BY updated_at ASC");
    $stmt2->bind_param("s", $invoice);
    $stmt2->execute();
    $logResults = $stmt2->get_result();
    $stmt2->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Track Shipment - MarketoLead</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-5">
    <div class="text-center mb-4">
        <h2 class="text-primary">📦 Track Your Shipment</h2>
        <p class="text-muted">Enter your Invoice Number to check shipment progress</p>
    </div>

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="POST" class="row g-3">
                <div class="col-md-10">
                    <input type="text" name="invoice" class="form-control" placeholder="Enter Invoice Number" value="<?= htmlspecialchars($invoice) ?>" required>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">🔍 Track</button>
                </div>
            </form>
        </div>
    </div>

    <?php if ($shipmentData !== null): ?>
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-success text-white">🧾 Shipment Info</div>
            <div class="card-body">
                <p><strong>Invoice:</strong> <?= htmlspecialchars($invoice) ?></p>
                <p><strong>Item:</strong> <?= htmlspecialchars($shipmentData["item_name"]) ?></p>
            </div>
        </div>

        <div class="card shadow-sm">
            <div class="card-header bg-dark text-white">🚚 Shipment Progress</div>
            <div class="card-body">
                <?php if ($logResults->num_rows > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="table-light">
                                <tr>
                                    <th>Date & Time</th>
                                    <th>Status</th>
                                    <th>City</th>
                                    <th>Country</th>
                                    <th>Description</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($log = $logResults->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $log["updated_at"] ?></td>
                                    <td><?= htmlspecialchars($log["status"]) ?></td>
                                    <td><?= htmlspecialchars($log["location_city"]) ?></td>
                                    <td><?= htmlspecialchars($log["location_country"]) ?></td>
                                    <td><?= htmlspecialchars($log["description"]) ?></td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning text-center">
                        ⚠️ No progress updates found yet.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php elseif ($_SERVER["REQUEST_METHOD"] == "POST"): ?>
        <div class="alert alert-danger text-center">
            ❌ No shipment found for invoice <strong><?= htmlspecialchars($invoice) ?></strong>
        </div>
    <?php endif; ?>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>